﻿#nullable enable
namespace Hims.Api.Models.Provider
{
    /// <summary>
    /// The provider upload document model.
    /// </summary>
    public class UploadProviderDocumentModel
    {
        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string EncryptedProviderId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the document (Base 64 Image String).
        /// </summary>
        public string Document { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the document url.
        /// </summary>
        public string DocumentUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string ThumbnailUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the document type.
        /// </summary>
        public string? DocumentType { get; set; }

        /// <summary>
        /// Gets or sets the document name.
        /// </summary>
        public string DocumentName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string? Description { get; set; }
    }
}
